' VKEY CODES:
' <a href="http://msdn.microsoft.com/en-us/library/windows/desktop/dd375731(v=VS.85).aspx" target="_blank">http://msdn.microsoft.com/en-us/library/windows/desktop/dd375731(v=VS.85).aspx</a>

' MODIFIER CONSTANTS HERE:
' <a href="http://msdn.microsoft.com/en-us/library/windows/Desktop/ms646309(v=VS.85).aspx" target="_blank">http://msdn.microsoft.com/en-us/library/windows/Desktop/ms646309(v=VS.85).aspx</a>

Import "elite.o"

Framework brl.basic
Import brl.GLMax2D
Import brl.Pixmap
Import brl.EventQueue
Import brl.jpgloader
Import maxgui.Drivers

Extern "Win32"

	Function SetWindowLong:Int(HWND:Int, nIndex:Int, dwNewLong:Int) = "SetWindowLongA@12"
	Function GetWindowLong:Int(HWND:Int, nIndex:Int) = "GetWindowLongA@8"
	Function CallWindowProc:Int(prevwndproc:Int, hwnd:Int, MSG:Int, wparam:Int, lparam:Int) = "CallWindowProcA@20"

EndExtern

IncBin "Splash.jpg"

Const MOD_ALT:Int = $0001
Const MOD_CONTROL:Int = $0002
Const MOD_NOREPEAT:Int = $4000
Const MOD_SHIFT:Int = $0004
Const MOD_WIN:Int = $0008
Const PRESSKEY:Int = $50  ' $50 = "P"
Const MENU_EXIT:Int = 1
Const GWL_WNDPROC:Int = -4
Const width:Int = 600
Const Height:Int = 330

Local RegisterHotkey:Int (hWnd:Int, id:Int, fsModifiers:Int, vk:Int) "win32"
Local user32 = LoadLibraryA ("user32.dll")
If user32 Then RegisterHotkey = GetProcAddress (user32, "RegisterHotKey")

AppTitle = "Elite Dangerous Anti-Panic Button"

Local Window:TGadget = CreateWindow ("Elite Dangerous Anti-Panic Button", ClientWidth(Desktop()) / 2 - (width / 2), ClientHeight(Desktop()) / 2 - (Height / 2), width, Height, Null, WINDOW_TITLEBAR | WINDOW_RESIZABLE)
Global canvas:TGadget = CreateCanvas(0, 0, width, Height, Window, 0)
SetPanelColor(Window, 0, 0, 0)
Global OldWindowFunc:Int = SetWindowFunc(Window, WindowFunc)

SetGadgetLayout canvas, 1, 1, 1, 1
SetGraphics CanvasGraphics(canvas)
ActivateGadget(canvas)
Local image:TPixmap = LoadPixmap("incbin::Splash.jpg")
DrawPixmap image, 0, 0

Local button:TGadget = CreateButton("Close", width / 2 - 60, Height - 140, 120, 30, canvas, BUTTON_PUSH)

RegisterHotkey (QueryGadget (Window, QUERY_HWND), 1, MOD_ALT, PRESSKEY)

While True

	WaitEvent()

	Select EventID()
		
		Case EVENT_WINDOWCLOSE
								End

		Case EVENT_APPTERMINATE
								End
		
		Case EVENT_TIMERTICK
								RedrawGadget canvas
		
		Case EVENT_GADGETPAINT
								SetGraphics CanvasGraphics(canvas)
								DrawPixmap image, 0, 0
						
								Flip False

		Case EVENT_GADGETACTION
								Select EventSource()
									
									Case button End
													
								EndSelect
	End Select
	
Wend

End

Function WindowFunc:Int(hwnd:Int, MSG:Int, wparam:Int, lparam:Int) "Win32"

	Select MSG
	
		Case WM_HOTKEY
								system_("taskkill /f /im EliteDangerous32.exe")
								system_("taskkill /f /im EliteDangerous64.exe")
								Notify "Elite Dangerous Process killed!"
			
		Case WM_DESTROY
								SetWindowLong(hwnd, GWL_WNDPROC, OldWindowFunc)
			
	End Select

	Return CallWindowProc(OldWindowFunc, hwnd, MSG, wparam, Int(lparam))

End Function

Function SetWindowFunc:Int(Window:TGadget, newfunc:Int(hwnd:Int, MSG:Int, wparam:Int, lparam:Int))
	
	Local hwnd:Int = QueryGadget(Window, QUERY_HWND)
	Local oldfunc:Int = GetWindowLong(hwnd, GWL_WNDPROC)
	
	SetWindowLong(hwnd, GWL_WNDPROC, Int(Byte Ptr newfunc))
	
	Return oldfunc
	
End Function